%% simulate some data
disp('Simulating some data: a gaussian peak');
echo on
x=0:500;
y=exp(-.5*((x-233)/20).^2);
%add noise above data;
sigma=0.04;
y=y+sigma*(randn(size(x)));
dy=ones(size(x))*sigma;
echo off

disp (' ')
disp ('Now fit intearactively these data to a gaussian peak.')
disp(['Type ''MIN'' to minimize chi-square, ''CALL 5'' to draw a plot, ',...
      '''EXI'' or ''RET''']) 
disp ('to return to Matlab');
disp (' ');

disp('[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy])');
disp ('Press any key')
pause

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy])

disp(['Repeat the fit in batch mode. Give also nicer names to the' ...
      ' parameters, and set ']);
disp('constraints to peak position and width');
echo on
lims=[2 0 500;3 .1 200];
names='Area X0 Sigma';
echo off
disp(['[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy],'...
      '''-b'',''-n'',names,''-s'',lims)']);
disp ('Press any key')
pause

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy],'-b','-n',...
		  'Area X0 Sigma','-s',[2 0 500;3 .1 200])



disp('Repeat last fit with a different sequence of MINUIT commands');
disp('Draw also a plot before leaving Fminuit')
echo on
close all;
cmd='fix 3; mini; call 5; rel 3; min; cal 5';
echo off 
disp(['[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy],'...
      '''-b'',''-n'',names,''-s'',lims,''-s'',cmd)']);

disp ('Press any key')
pause

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy],'-n',names,...
		  '-s',lims, '-c',cmd);
