%EXPDECAY    exponential decay function. 
%  Y0 = EXPDECAY(P,T) 
%  where P = [tau, Amplitude, Offset] are variational parameters,
%  and T is a vector, returns Y0 = Amplitude * exp(-T/tau) + Offset;
%
%  CHI2 = EXPDECAY(P,[T; Y; Delta_Y])
%  where Y and Delta_Y are experimental data and errorbar vectors, 
%  respectively, returns Chi-square:  CHI2 = sum(((Y-Y0)./Delta_Y).^);
%
%  CHI2 = EXPDECAY(P,[T; Y])
%  is the same as above, with Delta_Y = ones(size(T));  


function f = expdecay(par,data);  	
f = par(2) * exp(-data(1,:)./par(1)) + par(3); %theoretical function
if (size(data,1)==2),    %chi-square, error = 1
  f = sum((data(2,:) - f).^2);
elseif (size(data,1)>2), %chi-square, error = 3rd row of data
  f = sum(((data(2,:) - f)./data(3,:)).^2);
end


