%GAUSSIAN     Gaussian peak.
%  Y0 = GAUSSIAN(P,X) 
%  where P = [Area, Center, Sigma] are variational parameters,
%  and X is a vector, returns 
%  Y0 = Area/(sqrt(2*pi)*Sigma) * exp(-.5*((X - Center)/Sigma).^2);
%
%  CHI2 = GAUSSIAN(P,[X; Y; Delta_Y])
%  where Y and Delta_Y are experimental data and errorbar vectors, 
%  respectively, returns Chi-square:  CHI2 = sum(((Y-Y0)./Delta_Y).^);
%
%  CHI2 = GAUSSIAN(P,[X; Y])
%  is the same as above, with Delta_Y = ones(size(X));  


function f = gaussian(par,data);
%theoretical function
f = par(1)/(sqrt(2*pi)*par(3)) * exp(-.5*((data(1,:)-par(2))./par(3)).^2); 
if (size(data,1)==2),    %chi-square, error = 1
  f = sum((data(2,:) - f).^2);
elseif (size(data,1)>2), %chi-square, error = 3rd row of data
  f = sum(((data(2,:) - f)./data(3,:)).^2);
end


