%EXPDECAY2    exponential decay function. 
%  Y0 = EXPDECAY2(P,T) 
%  where P = [tau, Amplitude, Offset] are variational parameters,
%  and T is a vector, returns Y0 = Amplitude * exp(-T/tau) + Offset;
%
%  CHI2 = EXPDECAY2(P,DATASTRUCT)
%  with DATASTRUCT = struct('x',T,'y',Y,'dy',Delta_Y); where Y and
%  Delta_Y are vectors of experimental data and their errorbars, 
%  respectively, returns Chi-square:  CHI2 = sum(((Y-Y0)./Delta_Y).^);
%
%  CHI2 = EXPDECAY2(P,DATASTRUCT)
%  with DATASTRUCT = struct('x',T,'y',Y); does the same as above,
%  with Delta_Y = ones(size(T));  


function f = expdecay2(par,data);

if ~isstruct(data),
  f = par(2) * exp(-data(1,:)./par(1)) + par(3); %theoretical function
  return
else
  th = par(2) * exp(-data.x ./ par(1)) + par(3); %theoretical function
end  
if (~isfield(data,'dy')), %chi-square, error = 1
  f = sum((data.y - th).^2);
else                      %chi-square, error = 3rd row of data
  f = sum(((data.y - th)./data.dy).^2);
end


