function r=mnplot(par,aux,fcn,erma);
// MNPLOT    Auxiliary function for Fminuit: draws a run-time plot in response 
//  of a 'CALL 5' command. DATA is a 2- or 3-row matrix of experimental data
//  (DATA = [X_i;Y_i]; or  DATA = [X_i;Y_i; Delta_Y_i];).  
//  The user function FCN must be capable of switching between the theoretical 
//  function y=FCN(par,x) when its second argument is one row-vector, and the 
//  chi-square function when its second argument is a many-row matrix.  


[LHS,RHS] = argn(0);
brdrnd=10;
stat = %f;
if (RHS >2), 	
  if (typeof(fcn) == 'string'),
    l=min(aux(1,:)); r=max(aux(1,:)); 
    x =l: (r-l)/400:r;
    execstr(sprintf('y=%s(%s,%s);',fcn,'par','x'));
    // in Matlab was:		y= feval(fcn,par,x);
    stat = (length(y) == length(x));
  end
end

if (stat),
  xbasc();
  
  upbd=max(max(aux(2,:)),max(y)); 
  lwbd=min(min(aux(2,:)),min(y)); 
  rgbd=max(max(aux(1,:)),max(x)); 
  lfbd=min(min(aux(1,:)),min(x));
 
  mxabsy=max(abs([upbd lwbd]));
  if (mxabsy),
    [brd,tcy,stcy]=mkscale([lwbd upbd],[5,8]);
    lwbd=brd(1); upbd=brd(2);
  else
    lwbd=-1; upbd=1; tcy=2; stcy=1;
  end
    
  mxabsx=max(abs([r,l]));
  if (mxabsx),
    [brd,tcx,stcx]=mkscale([lfbd rgbd],[5,10]);
    lfbd=brd(1); rgbd=brd(2);
  else
    lfbd=-1; rgbd=1; tcx=2; stcx=1;
  end
  
  plot2d(aux(1,:)',aux(2,:)',-3,'011',' ', ...
      [lfbd,lwbd,rgbd,upbd],[stcx,tcx,stcy,tcy])
  plot2d(x',y',2,'000')
  //	drawnow;
  xselect();
else 
  disp('Nothing to plot');
end
r=0;
  


function [ax,nt,nst]=mkscale(rng,tck_mis); 
tckdef=5;
misdef=10;
//validate rng
if (rng(1)>rng(2))
  rng = rng(2:-1:1);
end
// validate tck_mis
[lhs,rhs]=argn(0);
if (rhs < 2),
  mintck=tckdef;
  misfac=misdef;
else
  mintck=round(abs(tck_mis(1)));
  if (length(tck_mis)<2),
    misfac=misdef;
  else
    misfac=abs(tck_mis(2));
  end
end
if (mintck> 10),
  mintck=10;
elseif (mintck < 2),
  mintck=2;
end
if (misfac>40),
  misfac=40;
end

facs=[.5 1 2 5 10 20 50 100];
smalltck=[4 2 5 4 2 5 4 2];
eps=1e4*%eps;
drng=rng(2)-rng(1);
if (drng),
  scala=10^(floor(log10(drng)));
  for i=1:length(facs);
    mantis=[floor(eps+facs(i)*rng(1)/scala),...
	    ceil(facs(i)*rng(2)/scala-eps)];
    ax=scala.*mantis./facs(i);
    nt=mantis(2)-mantis(1);
    mism=max(abs(rng-ax));
    nst=smalltck(i);

    if ((nt >= mintck) & (drng > mism*misfac)),
      break;
    end
  end
elseif (rng(1)),
  scala=10^(floor(log10(rng(1))));
  mantis=[floor(rng(1)/scala),ceil(rng(2)/scala)];
  if ~(mantis(2)-mantis(1)),
    mantis=mantis+[-1 1];
  end
  ax=scala.*mantis;
  nt=mantis(2)-mantis(1);
  nst=2;
else // all zeros: no scale
  ax=[-1 1];
  nt=2;
  nst=2;		
end

