//// simulate some data
mprintf('Simulating some data: a gaussian peak');

x=0:500;
y=exp(-.5*((x-233)/20).^2);
//add noise above data;
y=y+.01*(rand(x)-.5);
dy=ones(x)*.04;

mode(-1)
mprintf '\n'
mprintf 'Now fit intearactively these data to a gaussian peak.\n' 
mprintf('Type ''MIN'' to minimize chi-square, ''CALL 5'' to draw a ' + ...
      'plot, ''EXI'' or ''RET''\n') 
mprintf 'to return to Matlab\n';
mprintf '\n';

mprintf('[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy])\n');
mprintf 'Press any key\n'
input(' ','s');
mode(1)

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy])

mode(-1)

mprintf('Repeat the fit in batch mode. Give also nicer names to the' + ...
      ' parameters, and set\n');
mprintf('constraints to peak position and width\n');
mode(1)

lims=[2 0 500;3 .1 200];
names='Area X0 Sigma';

mode(-1)
mprintf('[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy],' + ...
      '''-b'',''-n'',names,''-s'',lims)\n');
mprintf 'Press any key\n'
input(' ','s');
mode(1)

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy],'-b','-n',...
		  'Area X0 Sigma','-s',[2 0 500;3 .1 200])


mode(-1)

mprintf('Repeat last fit with a different sequence of MINUIT commands\n');
mprintf('Draw also a plot before leaving Fminuit\n');
mode(1)

//close all;
cmd='fix 3; mini; call 5; rel 3; min; cal 5';

mode(-1)
mprintf(['[a b c] = fminuit(''gaussian'',''mnplot'',[10 166 33],[x;y;dy],'...
      '''-b'',''-n'',names,''-s'',lims,''-s'',cmd)\n']);

mprintf 'Press any key\n'
input(' ','s');
mode(1)

[a b c] = fminuit('gaussian','mnplot',[10 166 33],[x;y;dy],'-n',names,...
		  '-s',lims, '-c',cmd);
