%% simulate some data
disp('Simulating some data: a single exponential decay + constant offset');
echo on
x=0:500;
y=10*exp(-x/90)+.2;
%add noise above data;
sigma=0.1;
y=y+sigma*(randn(size(x)));
dy=ones(size(x))*sigma;
echo off

disp (' ')
disp ('Now fit intearactively these data to an exponential + offset.')
disp(['Type ''MIN'' to minimize chi-square, ''CALL 5'' to draw a plot, ',...
      '''EXI'' or ''RET''']) 
disp ('to return to Matlab');
disp (' ');

disp('[a b c] = fminuit(''expdecay'',''mnplot'',[10 20 1],[x;y;dy])');
disp ('Press any key')
pause

[a b c] = fminuit('expdecay','mnplot',[10 20 1],[x;y;dy])

disp(['Repeat the fit with halved errorbars. Chi-square should increase' ...
      ' by a factor of 4, but estimates of fitting parameters should ' ...
      'be more accurate.'])
disp(' ');
disp('[a b c] = fminuit(''expdecay'',''mnplot'',[10 20 1],[x;y;dy],1/2)');
disp ('Press any key')
pause
[a b c] = fminuit('expdecay','mnplot',[10 20 1],[x;y;dy],.5);

disp(['Repeat the fit in batch mode. Give also nicer names to the' ...
      ' parameters, and set ']);
disp('constraints to amplitude and offset');
echo on
lims=[2 0 500;3 -1 1];
names='tau Amplitude Offset';
echo off
disp(['[a b c] = fminuit(''expdecay'',''mnplot'',[10 20 1],[x;y;dy],'...
      '''-b'',''-n'',names,''-s'',lims)']);
disp ('Press any key')
pause

[a b c] = fminuit('expdecay','mnplot',[10 20 1],[x;y;dy],'-b','-n',...
		  'Area X0 Sigma','-s',[2 0 500;3 .1 200])



disp('Repeat last fit with a different sequence of MINUIT commands');
disp('Draw also a plot before leaving Fminuit')
echo on
close all;
cmd='fix 3; mini; call 5; rel 3; min; cal 5';
echo off 
disp(['[a b c] = fminuit(''expdecay'',''mnplot'',[10 166 33],[x;y;dy],'...
      '''-b'',''-n'',names,''-s'',lims,''-s'',cmd)']);

disp ('Press any key')
pause

[a b c] = fminuit('expdecay','mnplot',[10 20 1],[x;y;dy],'-n',names,...
		  '-s',lims, '-c',cmd);


