%MNPLOT2    Auxiliary function for Fminuit: draws a run-time plot in response 
%  of a 'CALL 5' command. Here DATA is a struct('x',X_i,'y',Y_i).
%  The user function FCN must be capable of switching between the theoretical 
%  function y=FCN(par,x) when its second argument is one row-vector, and the 
%  chi-square function when its second argument is a struct.

function dummy=mnplot2(par,data,fcn,erma);
stat = 0;
if (nargin >2), 	
  if (ischar(fcn)),
    l=min(data.x); r=max(data.x);
    x = l:(r-l)/500:r;
    y= feval(fcn,par,x);
    stat = (length(y) == length(x));
  end
end
if (stat),
  plot(data.x,data.y,'*',x,y,'-');
  drawnow;
else 
  disp('Nothing to plot');
end
dummy=[]; % return arg must be assigned

